﻿;
var vimeoListener = new PlayerEventsListener();

vimeoListener.getMediaId = function (player) {
    console.log("Media ID: " + player.assetId);
    return player.assetId;
};

vimeoListener.getPosition = function (player) {
    return player.getCurrentTime()
        .then(function (seconds) {
            console.log("Current Time: " + seconds);
            return seconds;
        }).catch(function (error) {
            // an error occurred
        });
};

vimeoListener.getDuration = function (player) {
    player.getDuration()
        .then(function (duration) {
            console.log("Duration: " + duration);
            return Math.round(duration);
        }).catch(function (error) {
            // an error occurred
        });
};

vimeoListener.onPlay = function (player) {
    console.log("Playback started");
    this.onMediaEvent(player, this.eventTypes.PlaybackStarted);
};

vimeoListener.onPlayed = function (player) {
    console.log("Playback finished");
    this.onMediaEvent(player, this.eventTypes.PlaybackCompleted);
};

vimeoListener.onPlayheadTimeChanged = function (player) {
    console.log("Playback Time Changed");
    this.onMediaEvent(player, this.eventTypes.PlaybackChanged);
};


vimeoListener.subscribeEvents = function (player) {
    if (player) {
        player.on('play', function () { vimeoListener.onPlay(player); });
        player.on('ended', function () { vimeoListener.onPlayed(player); });
        player.on('timeupdate', function () { vimeoListener.onPlayheadTimeChanged(player); });
        player.on('loaded', function () { vimeoListener.onMediaChanged(player); });
    }
};